DROP PROCEDURE [hips].[HL7MessageLogUpdate]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon Biber
-- Create date: 22/07/2012
-- Description:   Updates an existing record in the HL7 Message Log Table
-- 16/04/2013 - sbiber - Column IsSuccessful bit changed to QueueStatusId int
-- ============================================
CREATE PROCEDURE [hips].[HL7MessageLogUpdate] 
(
	 @HL7MessageLogId int
	,@HospitalId                 int = NULL
	,@HospitalPatientIdentifier  varchar(20)=NULL
	,@SendingApplication		 varchar(180) =NULL
	,@SendingFacility		     varchar(180) = NULL
	,@MessageControlId		     varchar(25) = NULL
	,@DateTimeOfMessage		     datetime = NULL
	,@QueueStatusId			     int
	,@ShouldRetry			     bit
	,@RetryCount        	     int 
	,@FailureReason			     varchar(256) = NULL
	,@FullMessage			     varchar(max) 
	,@UserModified               varchar(256)                          
    ,@DateModified               datetime
)
AS
BEGIN
    SET NOCOUNT ON
 DECLARE @intErrorCode int
    SET @intErrorCode = 0
    IF NOT EXISTS (SELECT TOP 1 [DateModified]
                FROM [hips].[HL7MessageLog]
        WHERE [HL7MessageLogId] = @HL7MessageLogId
        AND [DateModified] = @DateModified)
    BEGIN
        RAISERROR 50001 'Record has already been updated!'
        SET @intErrorCode = @@ERROR
    END
 IF @intErrorCode = 0
    BEGIN
        UPDATE [hips].[HL7MessageLog]
           SET  [HospitalId]        = @HospitalId               
       ,[HospitalPatientIdentifier]	= @HospitalPatientIdentifier
       ,[SendingApplication]		= @SendingApplication		  
       ,[SendingFacility]			= @SendingFacility		  
       ,[MessageControlId]			= @MessageControlId		  
       ,[DateTimeOfMessage]			= @DateTimeOfMessage		  
       ,[QueueStatusId]				= @QueueStatusId			  
       ,[ShouldRetry]				= @ShouldRetry			  
       ,[RetryCount]				= @RetryCount				  
       ,[FailureReason]				= @FailureReason			  
       ,[FullMessage]				= @FullMessage			  
             , [DateModified] = GetDate()
             , [UserModified] = @UserModified
           WHERE [HL7MessageLogId] = @HL7MessageLogId
        SELECT @intErrorCode = @@ERROR
    END
    IF @intErrorCode = 0
    BEGIN
           SELECT [HL7MessageLogId]
                , [HospitalId]
       ,[HospitalPatientIdentifier]
       ,[SendingApplication]
       ,[SendingFacility]
       ,[MessageControlId]
       ,[DateTimeOfMessage]
       ,[QueueStatusId]
       ,[ShouldRetry]
       ,[RetryCount]
       ,[FailureReason]
       ,[FullMessage]
       ,[DateCreated]
       ,[UserCreated]
       ,[DateModified]
       ,[UserModified]
                     FROM [hips].[HL7MessageLog] 
           WHERE [HL7MessageLogId] = @HL7MessageLogId
    END
    RETURN(@intErrorCode)
END

GO

